//  Copyright John Maddock 2006, 2007.
//  Copyright Paul A. Bristow 2006, 2007, 2009, 2010.

//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.lslboost.org/LICENSE_1_0.txt)

// This file includes *all* the distributions.
// this *may* be convenient if many are used
// - to avoid including each distribution individually.

#ifndef BOOST_MATH_DISTRIBUTIONS_HPP
#define BOOST_MATH_DISTRIBUTIONS_HPP

#include <lslboost/math/distributions/bernoulli.hpp>
#include <lslboost/math/distributions/beta.hpp>
#include <lslboost/math/distributions/binomial.hpp>
#include <lslboost/math/distributions/cauchy.hpp>
#include <lslboost/math/distributions/chi_squared.hpp>
#include <lslboost/math/distributions/complement.hpp>
#include <lslboost/math/distributions/exponential.hpp>
#include <lslboost/math/distributions/extreme_value.hpp>
#include <lslboost/math/distributions/fisher_f.hpp>
#include <lslboost/math/distributions/gamma.hpp>
#include <lslboost/math/distributions/geometric.hpp>
#include <lslboost/math/distributions/hypergeometric.hpp>
#include <lslboost/math/distributions/inverse_chi_squared.hpp>
#include <lslboost/math/distributions/inverse_gamma.hpp>
#include <lslboost/math/distributions/inverse_gaussian.hpp>
#include <lslboost/math/distributions/laplace.hpp>
#include <lslboost/math/distributions/logistic.hpp>
#include <lslboost/math/distributions/lognormal.hpp>
#include <lslboost/math/distributions/negative_binomial.hpp>
#include <lslboost/math/distributions/non_central_chi_squared.hpp>
#include <lslboost/math/distributions/non_central_beta.hpp>
#include <lslboost/math/distributions/non_central_f.hpp>
#include <lslboost/math/distributions/non_central_t.hpp>
#include <lslboost/math/distributions/normal.hpp>
#include <lslboost/math/distributions/pareto.hpp>
#include <lslboost/math/distributions/poisson.hpp>
#include <lslboost/math/distributions/rayleigh.hpp>
#include <lslboost/math/distributions/skew_normal.hpp>
#include <lslboost/math/distributions/students_t.hpp>
#include <lslboost/math/distributions/triangular.hpp>
#include <lslboost/math/distributions/uniform.hpp>
#include <lslboost/math/distributions/weibull.hpp>
#include <lslboost/math/distributions/find_scale.hpp>
#include <lslboost/math/distributions/find_location.hpp>

#endif // BOOST_MATH_DISTRIBUTIONS_HPP

