//  Copyright John Maddock 2006, 2007, 2012.
//  Copyright Paul A. Bristow 2006, 2007, 2012

//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.lslboost.org/LICENSE_1_0.txt)

// This file includes *all* the special functions.
// this may be useful if many are used
// - to avoid including each function individually.

#ifndef BOOST_MATH_SPECIAL_FUNCTIONS_HPP
#define BOOST_MATH_SPECIAL_FUNCTIONS_HPP

#include <lslboost/math/special_functions/airy.hpp>
#include <lslboost/math/special_functions/acosh.hpp>
#include <lslboost/math/special_functions/asinh.hpp>
#include <lslboost/math/special_functions/atanh.hpp>
#include <lslboost/math/special_functions/bessel.hpp>
#include <lslboost/math/special_functions/beta.hpp>
#include <lslboost/math/special_functions/binomial.hpp>
#include <lslboost/math/special_functions/cbrt.hpp>
#include <lslboost/math/special_functions/cos_pi.hpp>
#include <lslboost/math/special_functions/digamma.hpp>
#include <lslboost/math/special_functions/ellint_1.hpp>
#include <lslboost/math/special_functions/ellint_2.hpp>
#include <lslboost/math/special_functions/ellint_3.hpp>
#include <lslboost/math/special_functions/ellint_rc.hpp>
#include <lslboost/math/special_functions/ellint_rd.hpp>
#include <lslboost/math/special_functions/ellint_rf.hpp>
#include <lslboost/math/special_functions/ellint_rj.hpp>
#include <lslboost/math/special_functions/erf.hpp>
#include <lslboost/math/special_functions/expint.hpp>
#include <lslboost/math/special_functions/expm1.hpp>
#include <lslboost/math/special_functions/factorials.hpp>
#include <lslboost/math/special_functions/fpclassify.hpp>
#include <lslboost/math/special_functions/gamma.hpp>
#include <lslboost/math/special_functions/hermite.hpp>
#include <lslboost/math/special_functions/hypot.hpp>
#include <lslboost/math/special_functions/jacobi_elliptic.hpp>
#include <lslboost/math/special_functions/laguerre.hpp>
#include <lslboost/math/special_functions/lanczos.hpp>
#include <lslboost/math/special_functions/legendre.hpp>
#include <lslboost/math/special_functions/log1p.hpp>
#include <lslboost/math/special_functions/math_fwd.hpp>
#include <lslboost/math/special_functions/next.hpp>
#include <lslboost/math/special_functions/owens_t.hpp>
#include <lslboost/math/special_functions/powm1.hpp>
#include <lslboost/math/special_functions/sign.hpp>
#include <lslboost/math/special_functions/sin_pi.hpp>
#include <lslboost/math/special_functions/sinc.hpp>
#include <lslboost/math/special_functions/sinhc.hpp>
#include <lslboost/math/special_functions/spherical_harmonic.hpp>
#include <lslboost/math/special_functions/sqrt1pm1.hpp>
#include <lslboost/math/special_functions/zeta.hpp>
#include <lslboost/math/special_functions/modf.hpp>
#include <lslboost/math/special_functions/round.hpp>
#include <lslboost/math/special_functions/trunc.hpp>
#include <lslboost/math/special_functions/pow.hpp>
#include <lslboost/math/special_functions/next.hpp>
#include <lslboost/math/special_functions/owens_t.hpp>
#include <lslboost/math/special_functions/hankel.hpp>

#endif // BOOST_MATH_SPECIAL_FUNCTIONS_HPP
