function G = grammatrix(M, x, vectors)
% Computes the Gram matrix of tangent vectors in the Manopt framework.
%
% function G = grammatrix(M, x, vectors)
%
% M is a Manopt manifold structure obtained from a factory.
% x is a point on the manifold M.
% vectors is a cell containing n tangent vectors at x.
%
% G is an n-by-n symmetric positive semidefinite matrix such that G(i, j)
% is the inner product between vectors{i} and vectors{j}, with respect to
% the metric on the tangent space to M at x.
%
% See also: orthogonalize tangentorthobasis

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, April 28, 2016.
% Contributors: 
% Change log: 


    n = numel(vectors);
    
    G = zeros(n);
    
    for i = 1 : n
        
        vi = vectors{i};
        
        G(i, i) = M.inner(x, vi, vi);
        
        for j = (i+1) : n
            
            vj = vectors{j};
            G(i, j) = M.inner(x, vi, vj);
            
            % Manopt is designed to work with real inner products,
            % but it does not hurt to allow for complex inner products
            % here by taking the conjugate.
            G(j, i) = G(i, j)';
            
        end
        
    end

end
