% this function detects potential malware in the current folder and subfolders
%
% Author: A. Delorme, October 2013

% Copyright (C) Author: A. Delorme, October 2013
%
% This file is part of EEGLAB, see http://www.eeglab.org
% for the documentation and details.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
% this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
% this list of conditions and the following disclaimer in the documentation
% and/or other materials provided with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function detectmalware(currentFolder);

if nargin < 1
    currentFolder = pwd;
end

folderContent = dir(currentFolder);
folderContent = { folderContent.name };

malwareStrings = { 'eval(' 'evalin(' 'evalc(' 'delete(' 'movefile(' 'rmdir' 'mkdir' 'copyfile' 'system(' '!' };

for iFile = 1:length(folderContent)
    
    currentFile = folderContent{iFile};
    if length(currentFile) > 2 && strcmpi(currentFile(end-1:end), '.m')
        
        fid = fopen(fullfile(currentFolder, currentFile), 'r');
        countLine = 0;
        prevstr = '';
        while ~feof(fid)
            str = fgetl(fid);
            countLine = countLine+1;
        
            if length(str) > 1 && str(1) ~= '%'
                res = cellfun(@(x)~isempty(findstr(x, str)), malwareStrings(1:end-1));
                if str(1) == '!', res(end+1) = 1; end
                if any(res)
                    pos = find(res); pos = pos(1);
                    disp('************************************')
                    fprintf('Potential malware command detected containing "%s" in\n %s line %d\n', malwareStrings{pos}, fullfile(currentFolder, currentFile), countLine);
                    fprintf('%d: %s\n%d: %s\n%d: %s\n', countLine-1, prevstr, countLine, str, countLine+1, fgetl(fid));
                    countLine = countLine+1;
                end
            end
            
            prevstr = str;
        end
        fclose(fid);
        
    elseif exist(currentFile) == 7 && ~strcmpi(currentFile, '..') && ~strcmpi(currentFile, '.')
        detectmalware(fullfile(currentFolder, currentFile));
    end
end
