% Add Manopt to the path to make all manopt components available.

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, Jan. 3, 2013.
% Contributors: 
% Change log: 
%   Aug.  7, 2013 (NB): Changed to work without the import command
%                       (new structure of the toolbox).
%   Aug.  8, 2013 (NB): Changed to use addpath_recursive, home brewed.
%   Aug. 22, 2013 (NB): Using genpath instead of home cooked
%                       addpath_recursive.

addpath(pwd);

% Recursively add Manopt directories to the Matlab path.
cd manopt;
addpath(genpath(pwd));
cd ..;

% Ask user if the path should be saved or not
fprintf('Manopt was added to Matlab''s path.\n');
response = input('Save path for future Matlab sessions? [Y/N] ', 's');
if strcmpi(response, 'Y')
    failed = savepath();
    if ~failed
        fprintf('Path saved: no need to call importmanopt next time.\n');
    else
        fprintf(['Something went wrong.. Perhaps missing permission ' ...
                 'to write on pathdef.m?\nPath not saved: ' ...
                 'please re-call importmanopt next time.\n']);
    end
else
    fprintf('Path not saved: please re-call importmanopt next time.\n');
end
