%
%   popup menu for advanced asr options in dusk2dawn_clean 
%       - takes input cfg which might be empty or might have existing advanced settings from already opening the GUI
%       - if cancel, then doesn't save settings
%       - if ok, returns settings back to pop_dusk2dawn_clean
% 
% Dusk2Dawn
% Author: Richard Somervail, Istituto Italiano di Tecnologia, 2022
%           www.iannettilab.net 
function   out = advanced_popup_asr(in, plot, misc)

    %% if plot is selected then plot the actual GUI, else just return default parameters
    if plot

        % definitions
        indent1 = 0.05;
        veditbox = 1.2;
        v1 = 0.5;

        % build gui  ? will probably have to split this up the way I do for the top function for clarity
        geolocal = { ...
            1 ...  % main title
            1 ... 
            1 ... % ref tolerances title
            [ indent1 0.5 1 ] ... % ref tolerances editbox + help 1
            [ indent1 0.5 1 ] ... % help 2
            1 ... % max bad chans title
            [ indent1 0.5 1 ] ... % max bad chans editbox + help 1
            [ indent1 0.5 1 ] ... % help 2
            1 ... % ref_wndlen title
            [ indent1 0.5 1 ] ... % ref_wndlen editbox + help 1
            1 ... % 
            1 ... % asr_windowlength title
            [ indent1 0.5 1 ] ... % asr_windowlength editbox + help 1
            [ indent1 0.5 1 ] ... % help 2
            1 ... % asr_maxdims title
            [ indent1 0.5 1 ] ... % asr_maxdims editbox + help 
            1 ... 
            [ indent1 0.5 1 ] ... % asr_useGPU checkbox + help 1
            1 ... 
            1 ... % asr_UseRiemannian title
            [ indent1 0.5 1] ... % asr_UseRiemannian editbox + help
            1 ... 
            1 ... % memory title
            [ indent1 0.5 1] ... % memory editbox + help
            1 ... 
            1 ... % advanced d2d options title
            1 ... % sliding window overlap title
            [ indent1 0.5 1 ] ... % sliding window overlap edit box + help 1
            [ indent1 0.5 1 ] ... % help 2
            1 ...
            1 ... max ref time title
            [ indent1 0.5 1 ] ... % max ref time edit box + help 1
            [ indent1 0.5 1 ] ... % help 2
        };
        vertlocal = [ ...
            1 ...  % main title
            v1 ... 
            1 ... % ref tolerances title
            veditbox ... % ref tolerances editbox + help 1
            1 ... % ref tolerances help 2
            1 ... % ref max bad chans title
            veditbox ... % ref max bad chans editbox + help 1
            1 ... % help 2
            1 ... % ref_wndlen title
            veditbox ... % ref_wndlen editbox + help 1
            v1 ... % 
            1 ... % asr_windowlength title
            veditbox ... % asr_windowlength editbox + help 1
            1 ... % help 2
            1 ... % asr_maxdims title
            veditbox ... % asr_maxdims editbox + help 
            v1 ... % 
            1 ... % useGPU
            1 ... %
            1 ... % asr_UseRiemannian title
            1 ... % asr_UseRiemannian editbox + help
            1 ... %
            1 ... % memory title
            1 ... % memory editbox + help
            1 ... %
            1 ... % advanced d2d options title
            1 ... % sliding window overlap title 
            veditbox ... % sliding window overlap edit box + help 1
            1 ... % help 2
            1 ... % 
            1 ... % maxreftime title
            veditbox ... % maxreftime edit box + help 1
            1 ... % help 2
        ];
        uilocal = { ...
            { 'Style', 'text', 'string', 'Advanced ASR Options','fontweight','bold'} ...
            {} ...
            { 'Style', 'text', 'string', 'ref_tolerances - tolerances for acceptable calibration data: [min,max] (SD of RMS signal)'} ...
            {} ... 
                { 'Style', 'edit', 'string', in.ref_tolerances 'tag' 'ref_tolerances'  } ...
                { 'Style', 'text', 'string', '? ASR will automatically find data for calibration whose root-mean-square power does not exceed these','fontangle','italic'} ...
            {} ...
                {} ...
                { 'Style', 'text', 'string', '   tolerance values (e.g. by 5 SD). to try a range of this parameter use format: [-3.5,5; -3.5,10] etc','fontangle','italic'} ...
            { 'Style', 'text', 'string', 'ref_maxbadchannels - % max bad channels acceptable for calibration data:'} ...
            {} ...
                { 'Style', 'edit', 'string', in.ref_maxbadchannels 'tag' 'ref_maxbadchannels'  } ... 
                { 'Style', 'text', 'string', '? what percentage of channels can exceed the tolerance values above before','fontangle','italic'} ...
            {} ...
                {} ...
                { 'Style', 'text', 'string', '   that segment of data is excluded from the calibration','fontangle','italic'} ...
            { 'Style', 'text', 'string', 'ref_wndlen - timescale used to check data for artifacts when finding data for calibration'} ...
            {} ...
                { 'Style', 'edit', 'string', in.ref_wndlen 'tag' 'ref_wndlen'  } ... 
                { 'Style', 'text', 'string', '? ideally as long as the expected timescale of artifacts but not shorter than 0.5x cycle of the high-pass filter used','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', 'asr_windowlength - length of the sliding-window used by the ASR algorithm when cleaning (s)'} ...
            {} ...
                { 'Style', 'edit', 'string', in.asr_windowlength 'tag' 'asr_windowlength'  } ... 
                { 'Style', 'text', 'string', '? should not be much longer than the timescale over which artifacts persist, min = 1.5 x numchans / srate','fontangle','italic'} ...
            {} ...
                {} ...
                { 'Style', 'text', 'string', '   (note: this is not the optional D2D sliding window in which both cleaning and calibration are performed)','fontangle','italic'} ...
            { 'Style', 'text', 'string', 'asr_maxdims - maximum dimensions to remove from data'} ...
            {} ...
                { 'Style', 'edit', 'string', in.asr_maxdims 'tag' 'asr_maxdims'  } ... 
                { 'Style', 'text', 'string', '? removing too much may reduce resulting data quality, too little may fail to remove artifacts','fontangle','italic'} ...
            {} ...
            {} ...
                { 'Style', 'checkbox', 'string', 'use GPU for ASR processing?' 'value' in.asr_useGPU 'tag' 'asr_useGPU', 'callback', 'evalin("caller","callback_gpu")'} ...  %
                { 'Style', 'text', 'string', '? can speed up ASR processing, but requires a GPU with lots of memory and good double performance','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', 'asr_UseRiemannian - use Riemannian geometry instead of Euclidean'} ...
            {} ...
                { 'Style', 'edit', 'tag' 'asr_UseRiemannian', 'string', in.asr_UseRiemannian } ...
                { 'Style', 'text', 'string', '? typically faster than default ASR but still experimental as of 2022 (choose 0:1 to try both types)','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', 'asr_MaxMem - how much memory to use for ASR processing? (MB)'} ...
            {} ...
                { 'Style', 'edit', 'tag' 'asr_MaxMem', 'string', in.asr_MaxMem } ...
                { 'Style', 'text', 'string', '? more memory speeds up ASR, but this is limited by available memory during processing','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', 'Advanced Dusk2Dawn Options','fontweight','bold'} ...
            { 'Style', 'text', 'string', 'choose overlap of sliding windows (mins): '} ...
            {} ...
                { 'Style', 'edit', 'string', in.chunk_overlap 'tag' 'chunk_overlap'  } ... 
                { 'Style', 'text', 'string', '? something like 1 minute is probably fine, but you can vary this if unsure','fontangle','italic'} ...
            {} ...
                {} ... 
                { 'Style', 'text', 'string', '   although note that larger values result in longer computation time','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', 'choose maximum amount of reference data to use for calibration (s)'} ...
            {} ...
                { 'Style', 'edit', 'string', in.maxreftime 'tag' 'maxreftime'  } ... 
                { 'Style', 'text', 'string', '? excess data will be randomly excluded. can speed up processing but ','fontangle','italic'} ...
            {} ...
                {} ... 
                { 'Style', 'text', 'string', '   may make calibration less appropriate (less important when using sliding window)','fontangle','italic'} ...
        }; 

        %% run gui 
        [ ~, ~, strhalt_local, cfg_local ] = inputgui( 'geometry',geolocal, 'uilist',uilocal, 'geomvert',vertlocal, ...
           'title','Advanced Options - ASR Cleaning',  'helpcom', 'pophelp(''pop_dusk2dawn'');'); 
    
        % if clicked OK then return new settings
        if ~isempty(cfg_local)
            out = cfg_local;
        else
            out = in; % else don't change existing settings (return the same)
        end

    %% don't plot just return defaults 
    else
        % ASR defaults
        out.ref_tolerances = '[  -3.5,  5.5  ]';
        out.ref_maxbadchannels = '[   7.5   ]';
        out.ref_wndlen = '[   2   ]';
        out.asr_windowlength = ['[ '  num2str( max(3,1.5*misc.nbchan/misc.srate) , 8 )  ' ]'];
        out.asr_maxdims = '[  2/3  ]';
        out.asr_useGPU = 0;
        out.asr_UseRiemannian = '0';
        maxmem = d2d_recMaxMem(out.asr_useGPU);
        out.asr_MaxMem = [ num2str(maxmem/1024) '*1024' ];
        out.maxreftime = '[ ]';

        % d2d defaults
        out.chunk_overlap = '[ 1 ]';
    end

end % FUNCTION
