%
%   popup menu for advanced validation options in dusk2dawn_clean options  
%       - takes input cfg which might be empty or might have existing advanced settings from already opening the GUI
%       - if cancel, then doesn't save settings
%       - if ok, returns settings back to pop_dusk2dawn_clean
% 
% Dusk2Dawn
% Author: Richard Somervail, Istituto Italiano di Tecnologia, 2022
%           www.iannettilab.net 
function   out = advanced_popup_valid(in, plot, misc)

% get channel list for SW channel selection
fzs = cellfun( @(x) contains(x, 'fz','IgnoreCase',true),  misc.chans );
if any( fzs )
    sw_chan_default = find(fzs, 1,'first');
else
    sw_chan_default = 1;
end

    %% if plot is selected then plot the actual GUI, else just return default parameters
    if plot

        % build gui  ? will probably have to split this up the way I do for the top function for clarity
        long = 2;
        geolocal = { ...
            1 ... % title
            1 ... 
            1 ... % (1) fft title
            1 ... % fft freq bands title
            [ 1.5 1 ] ... % fft freq bands editboxes
            1 ...
            1 ... % fft freq labels title
            [ 1.5 1 ] ... % fft freq labels editboxes
            1 ...
            1 ...
            1 ... % (2) sw title
            [ 1 1 ] ... % sw sw_window title
            [ 0.5 long ] ... % sw sw_window editbox + help 1
            [ 0.5 long ] ... % sw sw_window help 2
            1 ...
            [1 3] ... % chan select title 
            [0.5 long] ... % chan select popup menu + help
            1 ...
            [ 1 3 ] ... % sw amp threshold title
            [ 0.5 long] ...  % sw amp threshold editbox + help line 1
            [ 0.5 long] ...  % sw amp threshold + help line 2
            1 ... 
            1 ... % (3) ica title
            [ 1 2 ] ... % ica num comps subtitle
            [ 0.5 long] ...  % ica num comps editbox + help 1st line
            [ 0.5 long] ...  % ica num comps help 2nd line
        };
        uilocal = { ...
            { 'Style', 'text', 'string', 'Advanced Validation Options','fontweight','bold'} ...
            {} ...
            { 'Style', 'text', 'string', '(1) Frequency Options','fontweight','bold'} ...
            { 'Style', 'text', 'string', 'frequency bands to compute per dataset (Hz): '} ...
            { 'Style', 'edit', 'string', in.fft_binFreqs 'tag' 'fft_binFreqs'  } ...
                {} ...
            {} ...
            { 'Style', 'text', 'string', 'labels for each frequency band: '} ...
            { 'Style', 'edit', 'string', in.fft_binFreqsLabels 'tag' 'fft_binFreqsLabels'  } ...  
                {} ...
            {} ...
            {} ...
            { 'Style', 'text', 'string', '(2) Slow wave Options','fontweight','bold'} ...
            { 'Style', 'text', 'string', 'peak window (ms):'} ...
                {} ...
            { 'Style', 'edit', 'string', in.sw_peakwin ,  'tag' 'sw_peakwin'  } ... 
                { 'Style', 'text', 'string', '? to quantify SW amplitude and consistency we find the peak within this window','fontangle','italic'} ...
            {} ...    
                { 'Style', 'text', 'string', '   around the SW event','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', 'peak channel:'} ...
                {} ...
            { 'Style', 'popupmenu', 'string', misc.chanlist , 'value', in.sw_chan,  'tag' 'sw_chan'  } ... 
                { 'Style', 'text', 'string', '? SW amplitude and consistency will be quantified using signal from this channel','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', 'amplitude threshold (uV):'} ...
                {} ... 
            { 'Style', 'edit', 'string', in.sw_ampThresh ,  'tag' 'sw_ampThresh'  } ...
                { 'Style', 'text', 'string', '? for auto-detection of SWs - only consider detected SWs with a minimum peak-to-peak','fontangle','italic'} ...
            {} ...
                { 'Style', 'text', 'string', '    amplitude above this threshold (needs to be positive)','fontangle','italic'} ...
            {} ...
            { 'Style', 'text', 'string', '(3) ICA Options','fontweight','bold'} ...
            { 'Style', 'text', 'string', ['number of ICs (max = ' num2str(length(misc.chans)) ')' ]  } ...
                {} ...
            { 'Style', 'edit', 'string', in.ica_numIC,  'tag' 'ica_numIC'  } ...  
                { 'Style', 'text', 'string', '? number of ICs should generally be equal to number of channels, although','fontangle','italic'} ...
            {} ...
                { 'Style', 'text', 'string', '   you can reduce a bit to speed up ICA computation (at the cost of IC underfitting)','fontangle','italic'} ...
        };


        %% run gui 
        [ ~, ~, strhalt_local, cfg_local ] = inputgui( 'geometry',geolocal, 'uilist',uilocal, ...
           'title','Advanced Options - Post-Cleaning Validation',  'helpcom', 'pophelp(''pop_dusk2dawn'');'); 
    
        % if clicked OK then return new settings
        if ~isempty(cfg_local)
            out = cfg_local;
        else
            out = in; % else don't change existing settings (return the same)
        end

    %% don't plot just return defaults 
    else
        out.fft_binFreqs = '[ 1,4;  4,8;  8,12;  12,16;  18,30;  30,45;  45,100 ]';
        out.fft_binFreqsLabels = ' { ''delta''; ''theta''; ''alpha''; ''sigma''; ''beta''; ''gammaLow''; ''gammaHigh'' }';
        
        out.sw_peakwin = '[ -50  50 ]';
        out.sw_chan = sw_chan_default;
        out.sw_ampThresh = '0';

        out.ica_numIC = num2str(length(misc.chans));

    end

end 
