% bids_template_README() - Create template README file
%                          from https://github.com/bids-standard/bids-starter-kit/tree/main/templates
%                          and adopted from FieldTrip implementation
% Usage:
%     strout = bids_template_README;
%
% Authors: Dung Truong, SCCN, INC, UCSD, April, 2024

% Copyright (C) Dung Truong, 2024
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
function strout = bids_template_README()
    strout = sprintf(['# README' ...
    '\n' ...
    '# WARNING' ...
    '\n' ...
    'Below is a template to write a README file for this BIDS dataset. If this message is still present, ' ...
    'it means that the person exporting the file has decided not to update the template.' ...
    'If you are the researcher editing this README file, please remove this warning section.' ...
    '\n' ...
    'The README is usually the starting point for researchers using your data' ...
    'and serves as a guidepost for users of your data. A clear and informative' ...
    'README makes your data much more usable.' ...
    '\n' ...
    'In general you can include information in the README that is not captured by some other' ...
    'files in the BIDS dataset (dataset_description.json, events.tsv, ...).' ...
    '\n' ...
    'It can also be useful to also include information that might already be' ...
    'present in another file of the dataset but might be important for users to be aware of' ...
    'before preprocessing or analysing the data.' ...
    '\n' ...
    'If the README gets too long you have the possibility to create a `/doc` folder' ...
    'and add it to the `.bidsignore` file to make sure it is ignored by the BIDS validator.' ...
    '\n' ...
    'More info here: https://neurostars.org/t/where-in-a-bids-dataset-should-i-put-notes-about-individual-mri-acqusitions/17315/3' ...
    '\n' ...
    '## Details related to access to the data' ...
    '\n' ...
    '- [ ] Data user agreement' ...
    '\n' ...
    'If the dataset requires a data user agreement, link to the relevant information.' ...
    '\n' ...
    '- [ ] Contact person' ...
    '\n' ...
    'Indicate the name and contact details (email and ORCID) of the person responsible for additional information.' ...
    '\n' ...
    '- [ ] Practical information to access the data' ...
    '\n' ...
    'If there is any special information related to access rights or' ...
    'how to download the data make sure to include it.' ...
    'For example, if the dataset was curated using datalad,' ...
    'make sure to include the relevant section from the datalad handbook:' ...
    'http://handbook.datalad.org/en/latest/basics/101-180-FAQ.html#how-can-i-help-others-get-started-with-a-shared-dataset' ...
    '\n' ...
    '## Overview' ...
    '\n' ...
    '- [ ] Project name (if relevant)' ...
    '\n' ...
    '- [ ] Year(s) that the project ran' ...
    '\n' ...
    'If no `scans.tsv` is included, this could at least cover when the data acquisition' ...
    'starter and ended. Local time of day is particularly relevant to subject state.' ...
    '\n' ...
    '- [ ] Brief overview of the tasks in the experiment' ...
    '\n' ...
    'A paragraph giving an overview of the experiment. This should include the' ...
    'goals or purpose and a discussion about how the experiment tries to achieve' ...
    'these goals.' ...
    '\n' ...
    '- [ ] Description of the contents of the dataset' ...
    '\n' ...
    'An easy thing to add is the output of the bids-validator that describes what type of' ...
    'data and the number of subject one can expect to find in the dataset.' ...
    '\n' ...
    '- [ ] Independent variables' ...
    '\n' ...
    'A brief discussion of condition variables (sometimes called contrasts' ...
    'or independent variables) that were varied across the experiment.' ...
    '\n' ...
    '- [ ] Dependent variables' ...
    '\n' ...
    'A brief discussion of the response variables (sometimes called the' ...
    'dependent variables) that were measured and or calculated to assess' ...
    'the effects of varying the condition variables. This might also include' ...
    'questionnaires administered to assess behavioral aspects of the experiment.' ...
    '\n' ...
    '- [ ] Control variables' ...
    '\n' ...
    'A brief discussion of the control variables --- that is what aspects' ...
    'were explicitly controlled in this experiment. The control variables might' ...
    'include subject pool, environmental conditions, set up, or other things' ...
    'that were explicitly controlled.' ...
    '\n' ...
    '- [ ] Quality assessment of the data' ...
    '\n' ...
    'Provide a short summary of the quality of the data ideally with descriptive statistics if relevant' ...
    'and with a link to more comprehensive description (like with MRIQC) if possible.' ...
    '\n' ...
    '## Methods' ...
    '\n' ...
    '### Subjects' ...
    '\n' ...
    'A brief sentence about the subject pool in this experiment.' ...
    '\n' ...
    'Remember that `Control` or `Patient` status should be defined in the `participants.tsv`' ...
    'using a group column.' ...
    '\n' ...
    '- [ ] Information about the recruitment procedure' ...
    '- [ ] Subject inclusion criteria (if relevant)' ...
    '- [ ] Subject exclusion criteria (if relevant)' ...
    '\n' ...
    '### Apparatus' ...
    '\n' ...
    'A summary of the equipment and environment setup for the' ...
    'experiment. For example, was the experiment performed in a shielded room' ...
    'with the subject seated in a fixed position.' ...
    '\n' ...
    '### Initial setup' ...
    '\n' ...
    'A summary of what setup was performed when a subject arrived.' ...
    '\n' ...
    '### Task organization' ...
    '\n' ...
    'How the tasks were organized for a session.' ...
    'This is particularly important because BIDS datasets usually have task data' ...
    'separated into different files.)' ...
    '\n' ...
    '- [ ] Was task order counter-balanced?' ...
    '- [ ] What other activities were interspersed between tasks?' ...
    '\n' ...
    '- [ ] In what order were the tasks and other activities performed?' ...
    '\n' ...
    '### Task details' ...
    '\n' ...
    'As much detail as possible about the task and the events that were recorded.' ...
    '\n' ...
    '### Additional data acquired' ...
    '\n' ...
    'A brief indication of data other than the' ...
    'imaging data that was acquired as part of this experiment. In addition' ...
    'to data from other modalities and behavioral data, this might include' ...
    'questionnaires and surveys, swabs, and clinical information. Indicate' ...
    'the availability of this data.' ...
    '\n' ...
    'This is especially relevant if the data are not included in a `phenotype` folder.' ...
    'https://bids-specification.readthedocs.io/en/stable/03-modality-agnostic-files.html#phenotypic-and-assessment-data' ...
    '\n' ...
    '### Experimental location' ...
    '\n' ...
    'This should include any additional information regarding the' ...
    'the geographical location and facility that cannot be included' ...
    'in the relevant json files.' ...
    '\n' ...
    '### Missing data' ...
    '\n' ...
    'Mention something if some participants are missing some aspects of the data.' ...
    'This can take the form of a processing log and/or abnormalities about the dataset.' ...
    '\n' ...
    'Some examples:' ...
    '\n' ...
    '- A brain lesion or defect only present in one participant' ...
    '- Some experimental conditions missing on a given run for a participant because' ...
    '  of some technical issue.' ...
    '- Any noticeable feature of the data for certain participants' ...
    '- Differences (even slight) in protocol for certain participants.' ...
    '\n' ...
    '### Notes' ...
    '\n' ...
    'Any additional information or pointers to information that' ...
    'might be helpful to users of the dataset. Include qualitative information' ...
    'related to how the data acquisition went.' ...
    '\n' ...
    ]); ...
