% eegplugin_eegbids() - EEGLAB plugin for importing data saved
%             by the finders course (Matlab converted)
%
% Usage:
%   >> eegplugin_eegbids(fig, trystrs, catchstrs);
%
% Inputs:
%   fig        - [integer]  EEGLAB figure
%   trystrs    - [struct] "try" strings for menu callbacks.
%   catchstrs  - [struct] "catch" strings for menu callbacks.

function vers = eegplugin_eegbids(fig, trystrs, catchstrs)

    vers = bids_matlab_tools_ver;
    if nargin < 3
        error('eegplugin_eegbids requires 3 arguments');
    end
    
    % add folder to path
    % ------------------
    p = which('pop_importbids.m');
    p = p(1:findstr(p,'pop_importbids.m')-1);
    if ~exist('jsonwrite')
        addpath( p );
        addpath( fullfile(p, 'JSONio'));
    end
    
    % find import data menu
    % ---------------------
    menui1 = findobj(fig, 'tag', 'import data');
    menui2 = findobj(fig, 'tag', 'export');
    menui3 = findobj(fig, 'label', 'File');
    
    % menu callbacks
    % --------------
    comcnt1 = [ trystrs.no_check '[STUDYTMP, ALLEEGTMP, ~, ~, LASTCOM] = pop_importbids; '  catchstrs.load_study ];
    comcnt2 = [ trystrs.no_check '[~,~,LASTCOM] = pop_exportbids(STUDY, EEG);' catchstrs.add_to_hist ];
                
    % create menus
    % ------------
    uimenu( menui1, 'label', 'From BIDS folder structure', 'separator', 'on', 'callback', comcnt1);
    uimenu( menui2, 'label', 'To BIDS folder structure', 'separator', 'on', 'callback', comcnt2, 'userdata', 'startup:off;study:on');
    set(menui2, 'userdata', 'startup:off;study:on');

    % create BIDS menus
    % -----------------
    comtaskinfo  = [trystrs.no_check '[EEG,LASTCOM] = pop_taskinfo(EEG);'               catchstrs.store_and_hist ];
    comsubjinfo  = [trystrs.no_check '[EEG,STUDY,LASTCOM] = pop_participantinfo(EEG,STUDY);'  catchstrs.store_and_hist ];
    comeventinfo = [trystrs.no_check '[EEG,STUDY,LASTCOM] = pop_eventinfo(EEG,STUDY);'        catchstrs.store_and_hist ];
%     comvalidatebids = [ trystrs.no_check 'if plugin_askinstall(''bids-validator'',''pop_validatebids'') == 1 pop_validatebids() end' catchstrs.add_to_hist ];
    bids = findobj(fig, 'label', 'BIDS tools');
    if isempty(bids)
        bids = uimenu( menui3, 'label', 'BIDS tools', 'separator', 'on', 'position', 5, 'userdata', 'startup:on;study:on');
    end
    children = get(bids, 'children');
    if ~isempty(children)
        delete(children);
    end
    
    uimenu( bids, 'label', 'BIDS export wizard (from raw EEG to BIDS)', 'callback', 'bids_exporter;');
    uimenu( bids, 'label', 'Import BIDS folder to STUDY', 'separator', 'on', 'callback', comcnt1);
    uimenu( bids, 'label', 'Export STUDY to BIDS folder', 'callback', comcnt2, 'userdata', 'startup:off;study:on');
    uimenu( bids, 'label', 'Edit BIDS task info', 'separator', 'on', 'callback', comtaskinfo, 'userdata', 'study:on');
    uimenu( bids, 'label', 'Edit BIDS participant info', 'callback', comsubjinfo, 'userdata', 'study:on');
    uimenu( bids, 'label', 'Edit BIDS event info', 'callback', comeventinfo, 'userdata', 'study:on');
    uimenu( bids, 'label', 'Validate BIDS dataset', 'separator', 'on', 'callback', 'web(''https://bids-standard.github.io/bids-validator/'')', 'userdata', 'startup:on;study:on');
    
    function validatebidsCB(src,event)
        if plugin_status('bids-validator') == 0
            plugin_askinstall('bids-validator');
        else
            pop_validatebids()
         end
    end
end
