function My_Autocorr(x, maxLag)
    % Simple autocorrelation plot (no Econometrics Toolbox needed)
    %
    % Usage: myAutocorr(data, maxLag)

    x = x(:) - mean(x);     % demean
    n = length(x);
    acf = zeros(maxLag+1,1);
    denom = x'*x;

    % compute autocorrelation
    for k = 0:maxLag
        acf(k+1) = (x(1:n-k)'*x(1+k:n)) / denom;
    end

    % plot
    stem(0:maxLag, acf, 'filled')
    xlabel('Lag')
    ylabel('Autocorrelation')
    title('Sample Autocorrelation Function')
    grid on
    ylim([-1 1])
end
