function createScreePlot(yy, ax)
% createScreePlot: combined version of createSP and createScreePlot
% Produces the scree plot of FPCA results
%
% Inputs:
%   yy : FPCA object returned from FPCA() or FPCder()
%   ax : (optional) axes handle to plot in. If missing, creates a new figure.

if nargin < 2
    figure;
    ax = gca;
end

% Get FVE, no_opt and yname from FPCA object
ops = getVal(yy,'ops');
yname = getVal(ops,'yname');
FVE = getVal(yy,'FVE');
no_opt = getVal(yy,'no_opt');

if isempty(yname)
    yname = 'y';
end

% Plot FVE
axes(ax); % make sure to plot into provided axes
hold(ax,'on');

plot(ax, 0:length(FVE), [0 FVE]*100, '--ro', ...
    'LineWidth',2, 'MarkerEdgeColor', 'k', 'MarkerFaceColor', 'g', 'MarkerSize',5);

xlabel(ax, '\bf{No. of Principal Components}');
ylabel(ax, '\bf{FVE (%)}');
title(ax, ['\bf{Fraction of variance explained by No. of PC for function ' yname '}']);

% Highlight chosen number of PCs
plot(ax, linspace(0,no_opt,30), ones(30,1)*FVE(no_opt)*100,'b', ...
         ones(30,1)*no_opt, linspace(0,FVE(no_opt)*100,30),'b');

text(ax, no_opt+0.2, FVE(no_opt)*100-10, ...
    {[' k = ' num2str(no_opt) ', FVE = ' num2str(round(FVE(no_opt)*100,3)) '%'] ' (final choice)'});

axis(ax, [0 length(FVE)+1 0 101]);
hold(ax,'off');

end