function S = importdata2(file_str)
%IMPORTDATA2   Read a Wearable Sensing CSV file and extract its information.
%   S = importdata2(file_str) reads the csv file with the path file_str and
%   returns parameter headers text as a cell column vector S.textdata, column headers
%   as a cell row vector S.colheaders and data matrix as S.data.
%
%   This script is intended to work with pop_WearableSensing, but can be
%   used as a standalone function to load Wearable Sensing data into MATLAB
%   as a struct containing the EEG matrix and the header data.
%
%Original Author: Umut Orhan
%Copyright: QUASAR 2011
%Modified and further developed by Steven Pillen
%Copyright: Wearable Sensing 2015
%% Open the .csv and set initial parameters
fid=fopen(file_str,'r');
line_cnt=1;
istextline=1; %this flag indicates whether 
comment = 0;
S.data = [];
while(istextline)
    tline = fgets(fid);
    istextline=any(isletter(tline));
    if any(strfind(tline,',Comment')) %this is an indication the file being loaded is from DSI-Streamer 0.734 or forward
        comment = 1;
        if comment == 1
            if strcmp(tline(1:4), 'Time') % The string Time is the indicator of the montage
                tline = strrep(tline, ',', ' ');
                tline = textscan(tline, '%s');
                S.colheaders = tline{1}';
                S.colheaders = S.colheaders(1:end-1);
                line_cnt=line_cnt+1;
                break
            end
        end
    end
    
    
    headers{line_cnt}=tline;
    line_cnt=line_cnt+1;
    
end
%% for files generated from DSI-Streamer versions 0734 and more recent
if comment == 1 %the presence of comments is the reason this distinction is drawn
    
    Filedata = fread(fid); %loads the binary data into the workspace
    Filedata = char(Filedata)'; %translates the binary into chars (necessary, because of the possible comments)
   
    Filedata = textscan(Filedata, '%s', 'Delimiter',char(10)); %this loads the rest of the data, separating it at any instance of an 'newline' char, i.e. the sort of thing hitting enter does. 
    Filedata = Filedata{1};                                    %cell arrays are weird, you have to specify the first index to get what's inside
%S.data = dlmread(file_str, ',', [ line_cnt, 0, length(Filedata)+line_cnt, length(S.colheaders)]);
% S.data = zeros(length(S.colheaders),length(Filedata));     %preallocating the matrix with zeros speeds things up immensely.
    for line = 1:(length(Filedata)-1);
        currentline = textscan(Filedata{line}, '%f', 'Delimiter',',');
        S.data(:,line) =  currentline{1};
%         currentline = textscan(Filedata{line}, '%f', 'Delimiter', ','); %this splits each line into a cell array of strings.
%         S.data(:,line) = str2double(currentline{1}(1:length(S.colheaders))); %this converts those string cells into actual numbers.
    end
   S.data = S.data'; %you have to flip the matrix for EEGLAB to be able to use it.
    S.textdata=headers'; %same with the headers.
    fclose(fid);
else
    %% for before 0734  (this is mostly Umut's code, largely untouched)
    fclose(fid);
    S.data=csvread(file_str,line_cnt-2);
    
    colheader_locs=findstr(headers{line_cnt-2},',');
    
    if(length(colheader_locs)+1==size(S.data,2))
        S.colheaders=cell(1,length(colheader_locs)+1);
        extended_colheader_locs=[0 colheader_locs length(headers{line_cnt-2})-1];
        for(ii=1:length(colheader_locs)+1)
            S.colheaders{ii}=headers{line_cnt-2}(extended_colheader_locs(ii)+1:extended_colheader_locs(ii+1)-1);
        end
        header_end=line_cnt-3;
    else
        header_end=line_cnt-2; %this is legacy for older versions 
    end
    
    S.textdata=headers(1:header_end)';
end
