/****************************************************************************
nstof.c

The nstof program converts a multiplexed shorts neuroscan.cnt file to a 
multiplexed float file.

*****************************************************************************
The syntax for the nstof program is:

nstof <complete file_name> <destination directory>

where:

<file_name> is the name and path of the continuous file to be converted, but 
with the .cnt extension omitted.  The output float file will have the name   
<file_name>.fdt and be in the destination directory.

****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "ns_cnt.h"

extern void writeHeadInfo( SETUP * );
extern void writeChanInfo( SETUP * );

void main(int argc, char *argv[])
{
    FILE *fp_fdt;             /* pointer for output float file          */
    SETUP *erp;               /* pointer to Neuro Scan header structure */
    EVENT2 *evt;              /* pointer to Neuro Scan event table      */
    long i,j;                 /* point and channel indices              */
    long count=0;             /* epoch or point counter                 */
    float **epoch;            /* pointer to multiplexed, uV-scaled data */
    float *flout;             /* pointer to output float buffer         */
    int chans, evnts;         /* number of eeg channels and events      */
	char outFileName[190];    /* name of the .cnt file to be processed  */
    char fn_fdt[200];         /* name of output float file              */
    char epoched_mode=0;      /* flag for discrete epochs               */
    unsigned short stim_type; /* stimulus type                          */

    printf("nstof: float conversion of Neuro Scan .cnt files\n");

    if (argc<=1) {
        printf("Please include command line parameter for file name.\n");
        goto error0;
    }

    /* open file, read header and event table    */
    if ((erp=ns_cnt_open(argv[1]))==NULL) 
        goto error0;

    /* get pointer to event table    */
    evt=ns_cnt_event_table();

    chans = erp->nchannels;
    evnts = ns_cnt_num_events();

	strcpy( outFileName, argv[2] );                 /* destination path */
	strcat( outFileName, strrchr( argv[1], '/' ) ); /* .cnt file name   */

    /* write event table information to a .evt file */
    if ( ! writeEventsInfo( evt, evnts, chans, outFileName ) ) {
        errmes("Unable to write event info to file ");
        goto error0;
    }

    /* open the float output file    */
	strcpy(fn_fdt,outFileName);
    strcat(fn_fdt,".fdt");
    if ( ( fp_fdt=fopen(fn_fdt,"w") ) == NULL ) {
        fprintf(stderr,"Unable to open float output file %s\n",fn_fdt);
        goto error1;
    }

    /* initialize epoch    */
    /* arguments represent: epoch_min,epoch_max,start_point,stop_point */
    if ((epoch=ns_cnt_initialize_epoch(0,0,0,-1))==NULL)
        goto error2;

    fprintf(stdout,"Continuous output mode\n");

    /* allocate the float output buffer array */
    if ( (flout=(float *)calloc((erp->pnts)*chans,sizeof(float)))
               == NULL ) {
        fprintf(stderr,"Unable to allocated float output buffer!\n");
        goto error1;
    }

    /* Main Loop: Read an epoch (or a point) at a time    */
    while (count=ns_cnt_read_epoch()) {

        for (i=0;i<erp->pnts;i++) {
            for (j=0;j<chans;j++) {
                flout[i*chans+j] = epoch[i][j];
            }
        }
        fwrite(flout,sizeof(float),chans*(erp->pnts),fp_fdt);
    }

    fclose(fp_fdt);         /* close float file    */
    ns_cnt_closeall();      /* cleanup ns_cnt resources    */
    printf("OK.\n");
    exit(0);

    error2: fclose(fp_fdt);
    error1: ns_cnt_closeall();
    error0: printf("Error.\n");
            exit(1);
}

