/*
 * swapBytes.c
 *
 * The function swap(), swaps the byte order within a short integer.
 *
 */

#include <stdio.h>

short swap(unsigned short data) {
   unsigned short tmp;
   unsigned short hi_mask = 0xff00;
   unsigned short lo_mask = 0x00ff;
   short value;

   tmp = data;
   data &= hi_mask;  tmp &= lo_mask;
   data >>= 8;       tmp <<= 8;
   data &= lo_mask;  tmp &= hi_mask;
   value = (short)(tmp | data);

   return( value );
}
