#include <stdio.h>
#include "eegdef.h"
#include "sethead.h"

#define SETUPSIZE 900
#define ELECTLOCSIZE 75

void writeChanInfo(SETUP *header) {
   int cnt;

   for ( cnt = 0; cnt < header->nchannels; cnt++ ) {
      printf("lab              : %s\n", header->elect_tab[cnt].lab);
      printf("reference        : %d\n", header->elect_tab[cnt].reference);
      printf("skip             : %d\n", header->elect_tab[cnt].skip);
      printf("reject           : %d\n", header->elect_tab[cnt].reject);
      printf("display          : %d\n", header->elect_tab[cnt].display);
      printf("bad              : %d\n", header->elect_tab[cnt].bad);
      printf("n                : %u\n", header->elect_tab[cnt].n);
      printf("avg_reference    : %d\n", header->elect_tab[cnt].avg_reference);
      printf("ClipAdd          : %d\n", header->elect_tab[cnt].ClipAdd);
      printf("x_coord          : %g\n", header->elect_tab[cnt].x_coord);
      printf("y_coord          : %g\n", header->elect_tab[cnt].y_coord);
      printf("veog_wt          : %g\n", header->elect_tab[cnt].veog_wt);
      printf("veog_std         : %g\n", header->elect_tab[cnt].veog_std);
      printf("snr              : %g\n", header->elect_tab[cnt].snr);
      printf("heog_wt          : %g\n", header->elect_tab[cnt].heog_wt);
      printf("heog_std         : %g\n", header->elect_tab[cnt].heog_std);
      printf("baseline         : %d\n", header->elect_tab[cnt].baseline);
      printf("Filtered         : %d\n", header->elect_tab[cnt].Filtered);
      printf("Fsp              : %d\n", header->elect_tab[cnt].Fsp);
      printf("aux1_wt          : %g\n", header->elect_tab[cnt].aux1_wt);
      printf("aux1_std         : %g\n", header->elect_tab[cnt].aux1_std);
      printf("sensitivity      : %g\n", header->elect_tab[cnt].sensitivity);
      printf("Gain             : %d\n", header->elect_tab[cnt].Gain);
      printf("HiPass           : %d\n", header->elect_tab[cnt].HiPass);
      printf("LoPass           : %d\n", header->elect_tab[cnt].LoPass);
      printf("Page             : %d\n", header->elect_tab[cnt].Page);
      printf("Size             : %d\n", header->elect_tab[cnt].Size);
      printf("Impedance        : %d\n", header->elect_tab[cnt].Impedance);
      printf("PhysicalChnl     : %d\n", header->elect_tab[cnt].PhysicalChnl);
      printf("Rectify          : %d\n", header->elect_tab[cnt].Rectify);
      printf("calib            : %g\n", header->elect_tab[cnt].calib);
   }
}

void writeHeadInfo(SETUP *header) {
        printf("rev             : %s\n", header->rev);
        printf("type            : %d\n", header->type);
        printf("id              : %s\n", header->id);
        printf("oper            : %s\n", header->oper);
        printf("doctor          : %s\n", header->doctor);
        printf("referral        : %s\n", header->referral);
        printf("hospital        : %s\n", header->hospital);
        printf("patient         : %s\n", header->patient);
        printf("age             : %d\n", header->age);
        printf("sex             : %c\n", header->sex);
        printf("hand            : %c\n", header->hand);
        printf("med             : %s\n", header->med);
        printf("class           : %s\n", header->class);
        printf("state           : %s\n", header->state);
        printf("label           : %s\n", header->label);
        printf("date            : %s\n", header->date);
        printf("time            : %s\n", header->time);
        printf("mean_age        : %g\n", header->mean_age);
        printf("stdev           : %g\n", header->stdev);
        printf("n               : %d\n", header->n);
        printf("compfile        : %s\n", header->compfile);
        printf("SpectWinComp    : %g\n", header->SpectWinComp);
        printf("MeanAccuracy    : %g\n", header->MeanAccuracy);
        printf("MeanLatency     : %g\n", header->MeanLatency);
        printf("sortfile        : %s\n", header->sortfile);
        printf("NumEvents       : %d\n", header->NumEvents);
        printf("compoper        : %d\n", header->compoper);
        printf("avgmode         : %d\n", header->avgmode);
        printf("review          : %d\n", header->review);
        printf("nsweeps         : %u\n", header->nsweeps);
        printf("compsweeps      : %u\n", header->compsweeps);
        printf("acceptcnt       : %u\n", header->acceptcnt);
        printf("rejectcnt       : %u\n", header->rejectcnt);
        printf("pnts            : %u\n", header->pnts);
        printf("nchannels       : %u\n", header->nchannels);
        printf("avgupdate       : %u\n", header->avgupdate);
        printf("domain          : %d\n", header->domain);
        printf("variance        : %d\n", header->variance);
        printf("rate            : %u\n", header->rate);
        printf("scale           : %g\n", header->scale);
        printf("veogcorrect     : %d\n", header->veogcorrect);
        printf("heogcorrect     : %d\n", header->heogcorrect);
        printf("aux1correct     : %d\n", header->aux1correct);
        printf("aux2correct     : %d\n", header->aux2correct);
        printf("veogtrig        : %g\n", header->veogtrig);
        printf("heogtrig        : %g\n", header->heogtrig);
        printf("aux1trig        : %g\n", header->aux1trig);
        printf("aux2trig        : %g\n", header->aux2trig);
        printf("heogchnl        : %d\n", header->heogchnl);
        printf("veogchnl        : %d\n", header->veogchnl);
        printf("aux1chnl        : %d\n", header->aux1chnl);
        printf("aux2chnl        : %d\n", header->aux2chnl);
        printf("veogdir         : %d\n", header->veogdir);
        printf("heogdir         : %d\n", header->heogdir);
        printf("aux1dir         : %d\n", header->aux1dir);
        printf("aux2dir         : %d\n", header->aux2dir);
        printf("veog_n          : %d\n", header->veog_n);
        printf("heog_n          : %d\n", header->heog_n);
        printf("aux1_n          : %d\n", header->aux1_n);
        printf("aux2_n          : %d\n", header->aux2_n);
        printf("veogmaxcnt      : %d\n", header->veogmaxcnt);
        printf("heogmaxcnt      : %d\n", header->heogmaxcnt);
        printf("aux1maxcnt      : %d\n", header->aux1maxcnt);
        printf("aux2maxcnt      : %d\n", header->aux2maxcnt);
        printf("veogmethod      : %d\n", header->veogmethod);
        printf("heogmethod      : %d\n", header->heogmethod);
        printf("aux1method      : %d\n", header->aux1method);
        printf("aux2method      : %d\n", header->aux2method);
        printf("AmpSensitivity  : %g\n", header->AmpSensitivity);
        printf("LowPass         : %d\n", header->LowPass);
        printf("HighPass        : %d\n", header->HighPass);
        printf("Notch           : %d\n", header->Notch);
        printf("AutoClipAdd     : %d\n", header->AutoClipAdd);
        printf("baseline        : %d\n", header->baseline);
        printf("offstart        : %g\n", header->offstart);
        printf("offstop         : %g\n", header->offstop);
        printf("reject          : %d\n", header->reject);
        printf("rejstart        : %g\n", header->rejstart);
        printf("rejstop         : %g\n", header->rejstop);
        printf("rejmin          : %g\n", header->rejmin);
        printf("rejmax          : %g\n", header->rejmax);
        printf("trigtype        : %d\n", header->trigtype);
        printf("trigval         : %g\n", header->trigval);
        printf("trigchnl        : %d\n", header->trigchnl);
        printf("trigmask        : %d\n", header->trigmask);
        printf("trigisi         : %g\n", header->trigisi);
        printf("trigmin         : %g\n", header->trigmin);
        printf("trigmax         : %g\n", header->trigmax);
        printf("trigdir         : %d\n", header->trigdir);
        printf("Autoscale       : %d\n", header->Autoscale);
        printf("n2              : %d\n", header->n2);
        printf("dir             : %d\n", header->dir);
        printf("dispmin         : %g\n", header->dispmin);
        printf("dispmax         : %g\n", header->dispmax);
        printf("xmin            : %g\n", header->xmin);
        printf("xmax            : %g\n", header->xmax);
        printf("AutoMin         : %g\n", header->AutoMin);
        printf("AutoMax         : %g\n", header->AutoMax);
        printf("zmin            : %g\n", header->zmin);
        printf("zmax            : %g\n", header->zmax);
        printf("lowcut          : %g\n", header->lowcut);
        printf("highcut         : %g\n", header->highcut);
        printf("common          : %d\n", header->common);
        printf("savemode        : %d\n", header->savemode);
        printf("manmode         : %d\n", header->manmode);
        printf("ref             : %s\n", header->ref);
        printf("Rectify         : %d\n", header->Rectify);
        printf("DisplayXmin     : %g\n", header->DisplayXmin);
        printf("DisplayXmax     : %g\n", header->DisplayXmax);
        printf("phase           : %d\n", header->phase);
        printf("screen          : %s\n", header->screen);
        printf("CalMode         : %d\n", header->CalMode);
        printf("CalMethod       : %d\n", header->CalMethod);
        printf("CalUpdate       : %d\n", header->CalUpdate);
        printf("CalBaseline     : %d\n", header->CalBaseline);
        printf("CalSweeps       : %d\n", header->CalSweeps);
        printf("CalAttenuator   : %g\n", header->CalAttenuator);
        printf("CalPulseVolt    : %g\n", header->CalPulseVolt);
        printf("CalPulseStart   : %g\n", header->CalPulseStart);
        printf("CalPulseStop    : %g\n", header->CalPulseStop);
        printf("CalFreq         : %g\n", header->CalFreq);
        printf("taskfile        : %s\n", header->taskfile);
        printf("seqfile         : %s\n", header->seqfile);
        printf("SpectMethod     : %d\n", header->SpectMethod);
        printf("SpectScaling    : %d\n", header->SpectScaling);
        printf("SpectWindow     : %d\n", header->SpectWindow);
        printf("SpectWinLength  : %g\n", header->SpectWinLength);
        printf("SpectOrder      : %d\n", header->SpectOrder);
        printf("NotchFilter     : %d\n", header->NotchFilter);
        printf("unused          : %s\n", header->unused);
        printf("FspStopMethod   : %d\n", header->FspStopMethod);
        printf("FspStopMode     : %d\n", header->FspStopMode);
        printf("FspFValue       : %g\n", header->FspFValue);
        printf("FspPoint        : %u\n", header->FspPoint);
        printf("FspBlockSize    : %u\n", header->FspBlockSize);
        printf("FspP1           : %u\n", header->FspP1);
        printf("FspP2           : %u\n", header->FspP2);
        printf("FspAlpha        : %g\n", header->FspAlpha);
        printf("FspNoise        : %g\n", header->FspNoise);
        printf("FspV1           : %u\n", header->FspV1);
        printf("montage         : %s\n", header->montage);
        printf("EventFile       : %s\n", header->EventFile);
        printf("fratio          : %g\n", header->fratio);
        printf("minor_rev       : %c\n", header->minor_rev);
        printf("eegupdate       : %u\n", header->eegupdate);
        printf("compressed      : %d\n", header->compressed);
        printf("xscale          : %g\n", header->xscale);
        printf("yscale          : %g\n", header->yscale);
        printf("xsize           : %g\n", header->xsize);
        printf("ysize           : %g\n", header->ysize);
        printf("ACmode          : %d\n", header->ACmode);
        printf("CommonChnl      : %d\n", header->CommonChnl);
        printf("Xtics           : %d\n", header->Xtics);
        printf("Xrange          : %d\n", header->Xrange);
        printf("Ytics           : %d\n", header->Ytics);
        printf("Yrange          : %d\n", header->Yrange);
        printf("XScaleValue     : %g\n", header->XScaleValue);
        printf("XScaleInterval  : %g\n", header->XScaleInterval);
        printf("YScaleValue     : %g\n", header->YScaleValue);
        printf("YScaleInterval  : %g\n", header->YScaleInterval);
        printf("ScaleToolX1     : %g\n", header->ScaleToolX1);
        printf("ScaleToolY1     : %g\n", header->ScaleToolY1);
        printf("ScaleToolX2     : %g\n", header->ScaleToolX2);
        printf("ScaleToolY2     : %g\n", header->ScaleToolY2);
        printf("port            : %d\n", header->port);
        printf("NumSamples      : %ld\n", header->NumSamples);
        printf("FilterFlag      : %d\n", header->FilterFlag);
        printf("LowCutoff       : %g\n", header->LowCutoff);
        printf("LowPoles        : %d\n", header->LowPoles);
        printf("HighCutoff      : %g\n", header->HighCutoff);
        printf("HighPoles       : %d\n", header->HighPoles);
        printf("FilterType      : %d\n", header->FilterType);
        printf("FilterDomain    : %d\n", header->FilterDomain);
        printf("SnrFlag         : %d\n", header->SnrFlag);
        printf("CoherenceFlag   : %d\n", header->CoherenceFlag);
        printf("ContinousType   : %d\n", header->ContinousType);
        printf("EventTablePos   : %ld\n", header->EventTablePos);
        printf("ContinousSeconds: %g\n", header->ContinousSeconds);
        printf("ChannelOffset   : %ld\n", header->ChannelOffset);
        printf("AutoCorrectFlag : %d\n", header->AutoCorrectFlag);
        printf("DCThreshold     : %c\n", header->DCThreshold);
		printf("\n");
}

int writeEventsInfo(EVENT2 *evt, long numEvents, int chans, char *file) {
   FILE *fp;
   char fileName[200];
   long headSize = (SETUPSIZE + ELECTLOCSIZE*chans);
   int i;

   strcpy(fileName,file);
   strcat(fileName,".evt");

   if ( ( fp = fopen(fileName,"w") ) == NULL )
	  return 0;

   for ( i = 0; i < numEvents; i++ ) {
      fprintf(fp,"StimType : %u\n",   evt[i].Event1.StimType);
      fprintf(fp,"KeyBoard : %u\n",   evt[i].Event1.KeyBoard);
      fprintf(fp,"KeyPad   : %x\n",   evt[i].Event1.KeyPad);
      fprintf(fp,"Accept   : %x\n",   evt[i].Event1.Accept);
      fprintf(fp,"Offset   : %ld\n", (evt[i].Event1.Offset-headSize)/2/32);
      fprintf(fp,"\n");
   }

   fclose(fp);
   return 1;
}

void writeTEEGinfo( TEEG *teeg ) {
   printf("Teeg   : %d\n", teeg->Teeg);
   printf("Size   : %ld\n", teeg->Size);
   printf("Union  : %ld\n", teeg->u.Offset);
}
