/*count_stimuli.c - count the stimuli generated by sequence.c.
  Copyright (c) 1996 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

#include <stdio.h>

void main()
  {
  FILE *stimuli;
  register int interval, start_of_trial, line, last_break;
  int code, bin[21];
  printf("Copyright (c) 1996 Matthew Belmonte <mkb4@Cornell.edu>.  Please cite.\n");
  for(interval = 0; interval != 21; interval++)
    bin[interval] = 0;
  start_of_trial = 1;
  interval = 0;
  line = 0;
  last_break = 1;
  stimuli = fopen("stimuli.dat", "r");
  while(fscanf(stimuli, "%d", &code) == 1)
    {
    line++;
    if(code == 254)
      {
      start_of_trial = 1;
      printf("TRIAL DURATION %f\n", (line-last_break)*0.056);
      last_break = line+1;
      }
    else if(code & 1)
      interval++;
    else
      {
      if(!start_of_trial)
	{
	bin[interval/2]++;
	if(interval & 1)
	  fprintf(stderr, "error: uneven interval, ending at line %d\n", line);
	if(interval/2 > 20)
	  fprintf(stderr, "error: interval of length %d, ending at line %d\n", interval, line);
	}
      start_of_trial = 0;
      interval = 0;
      }
    }
  fclose(stimuli);
  for(interval = 0; interval != 21; interval++)
    printf("bin %d: %3d\n", interval, bin[interval]);
  exit(0);
  }
