/*dumpevtb.c - generate an ASCII dump of the event table of a GnuroScan
  continuous file.
  Copyright (c) 1996 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

#include <stdio.h>
#include <unistd.h>
#include "gnuro.h"
#include "intel.h"

void main(argc, argv)
int argc;
char **argv;
  {
  register long event;
  long num_events;
  int scored, epoched;
  short num_channels, srate, code;
  float resp;
  long time;
  FILE *cnt;
  fprintf(stderr, "Copyright (c) 1996 Matthew Belmonte <mkb4@Cornell.edu>.  Please cite.\n");
  if(argc != 2)
    exit(1);
  printf("event typ   offset art resp e a h\n");
  cnt = fopen(argv[1], "r");
  fseek(cnt, S_nchans_offset, SEEK_SET);
  num_channels = read_Intel_short(cnt);
  fseek(cnt, S_rate_offset, SEEK_SET);
  srate = read_Intel_short(cnt);
  fseek(cnt, S_EventTablePos_offset, SEEK_SET);
  fseek(cnt, read_Intel_long(cnt), SEEK_SET);
  scored = getc(cnt)-1;
  num_events = read_Intel_long(cnt)/(scored? 19L: 8L);
  fseek(cnt, read_Intel_long(cnt), SEEK_CUR);
  for(event = 0L; event != num_events; event++)
    {
    printf("%5ld %3d ", event, read_Intel_short(cnt));
    fseek(cnt, 2L, SEEK_CUR);
    time = 1000L*(read_Intel_long(cnt)-packed_sizeof_SETUP-num_channels*packed_sizeof_ELECTLOC)/(num_channels*sizeof(short))/srate;
    printf("%4ld.%03ld ", time/1000L, time%1000L);
    if(scored)
      {
      fseek(cnt, 2L, SEEK_CUR);
      code = read_Intel_short(cnt);
      if(code == 0)
	printf("    ");
      else
	printf("%3d ", code);
      resp = read_Intel_float(cnt);
      if(resp == 0.0)
	printf("     ");
      else
	printf("%4.0f ", resp*1000.0);
      epoched = getc(cnt);
      printf("%c ", epoched? 'E': ' ');
      printf("%c ", getc(cnt)? ' ': 'R');
      printf("%c\n", (getc(cnt)||!epoched)? ' ': 'M');
      }
    }
  fclose(cnt);
  exit(0);
  }
