/*fastshft.h - common header file for sequence.c & fastshft.c.
  Copyright (c) 1996 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

/*event codes*/
#define EV_RESPONSE 200 /*200=left, 201=right*/
#define EV_HEOG_CALIB 251 /*horizontal eye movement calibration point*/
#define EV_START 252    /*start of trial; 252=attend left, 253=attend right*/
#define EV_FINISH 254   /*end of trial*/
/*THE FOLLOWING CODES ARE HARDCODED IN sequence.c AND score.c:
  left nontarget stimulus  1
  left target stimulus     2
  right nontarget stimulus 3
  right target stimulus    4 */

/*condition codes*/
#define CC_BLINK 1
#define CC_SACCADE 2

/*stimulus and response timing*/
#define ST_FASTEST_RESPONSE 200	/*earliest valid response after target*/
#define ST_SLOWEST_RESPONSE 1400 /*latest valid response after target*/
#define ST_MSECS_PER_TICK 112	/*duration of a pair of stimuli (ms)*/
#define ST_LONGEST_ISI 2240	/*longest inter-target interval (ms)*/
#define ST_MSECS_PER_TRIAL 16000 /*desired duration of each trial (ms)*/
/*Due to an unknown bug, the program acts as if this value were about 3 times
  larger than it actually is.  10000 gives about 24s, 12000 gives about 31s.*/
#define ST_LATENCY 11.71875	/*hardware latency from event code to stimulus onset (ms)*/
#define ST_ANGLE 12.0		/*angular separation of stimuli (degrees)*/

/*rejection*/
#define RE_MAX_CALIB_INTERVAL 20 /*max time between HEOG calibration marks (s)*/
#define RE_MIN_CALIB_LEVEL 20.0 /*min. valid HEOG calib. voltage (uV/degree)*/
#define RE_DFL_CALIB_LEVEL 25.0	/*default HEOG voltage if no calib.(uV/degree)*/
#define RE_NUM_HEOG_CALIBS 64	/*maximum # of HEOG calibration marks*/
#define RE_SACC_THRESH 1.0	/*threshold for saccade rejection (degrees)*/
#define RE_SACC_DERIV_LEN 75	/*time window for threshold test (ms)*/
#define RE_SACC_FILTER_LEN (3*ST_MSECS_PER_TICK) /*median-filter window (ms)*/
#define RE_BLINK_THRESH 100.0	/*threshold for blink identification (uV)*/
#define RE_BLINK_DERIV_LEN 300	/*usual blink duration (ms)*/
#define RE_BLINK_FILTER_LEN 75	/*blinks don't happen faster than this (ms)*/
/*These 'LEN' values are not the same as rejection window lengths - rejection
  window lengths vary with the averaging window lengths as implemented by
  average.c.*/
/*NOTE: score.c requires RE_SACC_DERIV_LEN+RE_SACC_FILTER_LEN >= RE_BLINK_DERIV_LEN+RE_BLINK_FILTER_LEN*/

/*averaging*/
#define AV_BIN_SIZE 20		/*desired size of smallest ISI bin*/
#define CH_MAX 16		/*maximum # of channels*/
#define AV_MAX_SRATE 286	/*maximum sampling rate*/
#define AV_MAX_FFT_LENGTH 32	/* >= ST_MSECS_PER_TICK*AV_MAX_SRATE/1000 */
#define AV_NUM_BINS 4		/*# of ITI bins (incl. 1 bin for infinity)*/
#define AV_HISTO_MAXV 100	/*pos. & neg. range of HEOG histograms (uV)*/

#define MAX_QLEN (((long)RE_SACC_FILTER_LEN)*AV_MAX_SRATE/1000L)
