/*gnuro.h - definitions for GnuroScan file formats.
  Copyright (c) 1995 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

#define S_pnts_offset 368
#define S_nchans_offset 370
#define S_variance_offset 375
#define S_rate_offset 376
#define S_xmin_offset 505
#define S_xmax_offset 509
#define S_AutoMin_offset 513
#define S_AutoMax_offset 517
#define S_EventTablePos_offset 886
#define packed_sizeof_SETUP 900

#define S_type(setup) (setup[20])
#define S_NumEvents(setup) (fetch_Intel_short(setup, 355))
#define S_review(setup) (setup[359])
#define S_nsweeps(setup) (fetch_Intel_short(setup, 360))
#define S_compsweeps(setup) (fetch_Intel_short(setup, 362))
#define S_acceptcnt(setup) (fetch_Intel_short(setup, 364))
#define S_rejectcnt(setup) (fetch_Intel_short(setup, 366))
#define S_pnts(setup) (fetch_Intel_short(setup, 368))
#define S_nchannels(setup) (fetch_Intel_short(setup, 370))
#define S_domain(setup) (setup[374])
#define S_variance(setup) (setup[375])
#define S_rate(setup) (fetch_Intel_short(setup, 376))
#define S_xmin(setup) (fetch_Intel_float(setup, 505))
#define S_xmax(setup) (fetch_Intel_float(setup, 509))
#define S_NumSamples(setup) (fetch_Intel_long(setup, 864))
#define S_EventTablePos(setup) (fetch_Intel_long(setup, 886))

#define put_S_NumEvents(setup, n) (store_Intel_short(setup, 355, n))
#define put_S_nsweeps(setup, n) (store_Intel_short(setup, 360, n))
#define put_S_compsweeps(setup, n) (store_Intel_short(setup, 362, n))
#define put_S_acceptcnt(setup, n) (store_Intel_short(setup, 364, n))
#define put_S_rejectcnt(setup, n) (store_Intel_short(setup, 366, n))
#define put_S_pnts(setup, pnts) (store_Intel_short(setup, 368, pnts))
#define put_S_nchannels(setup, n) (store_Intel_short(setup, 370, n))
#define put_S_rejstart(setup, t) (store_Intel_float(setup, 456, t))
#define put_S_rejstop(setup, t) (store_Intel_float(setup, 460, t))
#define put_S_xmin(setup, t) (store_Intel_float(setup, 505, t))
#define put_S_xmax(setup, t) (store_Intel_float(setup, 509, t))
#define put_S_AutoMin(setup, t) (store_Intel_float(setup, 513, t))
#define put_S_AutoMax(setup, t) (store_Intel_float(setup, 517, t))
#define put_S_DisplayXmin(setup, t) (store_Intel_float(setup, 551, t))
#define put_S_DisplayXmax(setup, t) (store_Intel_float(setup, 555, t))
#define put_S_NumSamples(setup, n) (store_Intel_long(setup, 864, n))
#define put_S_EventTablePos(setup, x) (store_Intel_long(setup, 886, x))

#define EL_lab_offset 0
#define EL_lab_length 10
#define EL_baseline_offset 47
#define EL_calib_offset 71
#define packed_sizeof_ELECTLOC 75

#define EL_lab(electloc) (electloc)
#define EL_baseline(electloc) (fetch_Intel_short(electloc, 47))
#define EL_sensitivity(electloc) (fetch_Intel_float(electloc, 59))
#define EL_calib(electloc) (fetch_Intel_float(electloc, 71))

#define put_EL_n(electloc, n) (store_Intel_short(electloc, 15, n))
#define put_EL_baseline(electloc, b) (store_Intel_short(electloc, 47, b))
#define put_EL_sensitivity(electloc, s) (store_Intel_float(electloc, 59, s))
#define put_EL_calib(electloc, c) (store_Intel_float(electloc, 71, c))

#define packed_sizeof_TEEG 9
#define T_Teeg(teeg) (*teeg)
#define T_Size(teeg) (fetch_Intel_long(teeg, 1))
#define T_Offset(teeg) (fetch_Intel_long(teeg, 5))

#define put_T_Size(teeg, s) (store_Intel_long(teeg, 1, s))
#define put_T_Offset(teeg, o) (store_Intel_long(teeg, 5, o))

#define packed_sizeof_EVENT1 8
#define packed_sizeof_EVENT2 19
#define TEEG_EVENT_TAB1 1
#define TEEG_EVENT_TAB2 2

#define E_StimType(evt2) (fetch_Intel_short(evt2, 0))
#define E_Offset(evt2) (fetch_Intel_long(evt2, 4))
#define E_Code(evt2) (fetch_Intel_short(evt2, 10))
#define E_EpochEvent(evt2) (evt2[16])
#define E_Accept(evt2) (evt2[17])
#define E_Accuracy(evt2) (evt2[18])
#define E_Latency(evt2) (fetch_Intel_float(evt2, 12))

#define put_E_StimType(evt2, s) (store_Intel_short(evt2, 0, s))
#define put_E_Offset(evt2, o) (store_Intel_long(evt2, 4, o))
#define put_E_Type(evt2, t) (store_Intel_short(evt2, 8, t))
#define put_E_Code(evt2, c) (store_Intel_short(evt2, 10, c))
#define put_E_Latency(evt2, l) (store_Intel_float(evt2, 12, l))
