/*intel.h - header file for libintel.c
  Copyright (c) 1995 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

extern short fetch_Intel_short(char *, int);
extern void store_Intel_short(char *, int, short);
extern long fetch_Intel_long(char *, int);
extern void store_Intel_long(char *, int, long);
extern double fetch_Intel_float(char *, int);
extern void store_Intel_float(char *, int, double);
extern short read_Intel_short(FILE *);
extern void write_Intel_short(short, FILE *);
extern long read_Intel_long(FILE *);
extern void write_Intel_long(long, FILE *);
extern double read_Intel_float(FILE *);
extern void write_Intel_float(double, FILE *);
