/*median.h - header file for median.c.
  Copyright (c) 1995 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

typedef short QVAL; /*change this to whatever type you want to operate on*/

typedef struct _node {
  QVAL value;
  int ref_count, subtree_ref_count;
  struct _node *parent, *left_child, *right_child;
  } node;
#define NULLTREE ((node *)0)

typedef struct {
  node *tree;
  int (*compare)(QVAL*, QVAL*);
  int head, tail, qsize;
  node **queue;
  } btree;

btree *create_btree(int);	/*create a btree to hold up to 'int' items*/
void destroy_btree(btree*);	/*clean up storage when done using a btree*/
void insert_newest(/* QVAL, btree* */); /*insert a new value into a btree*/
void delete_oldest(btree*);	/*delete the least recently inserted value*/
QVAL extract_median(btree*);	/*find median, but leave the btree unchanged*/
QVAL extract_minimum(btree*);	/*find minimum, but leave the btree unchanged*/
QVAL extract_maximum(btree*);	/*find maximum, but leave the btree unchanged*/
int search_btree(/* QVAL, btree* */); /*search for a value in a btree*/
int traverse_btree(/* btree*, QVAL* */); /*traverse a btree*/
