/*scale.c - scale a GnuroScan averaged EEG data file.
  Copyright (c) 1996 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include "intel.h"
#include "gnuro.h"

void main(argc, argv)
int argc;
char **argv;
  {
  register int channel, sample;
  unsigned char sign_byte;
  int num_samples, num_channels;
  float s, calibration_factor;
  FILE *fp;
  printf("Copyright (c) 1996 Matthew Belmonte <mkb4@Cornell.edu>.  Please cite.\n");
  if(argc != 3)
    {
    fprintf(stderr, "usage: %s <GnuroScan file> <scaling coefficient>\n", *argv);
    exit(1);
    }
/*if the first character in the scaling factor is '/', treat is as a divisor
  instead of a multiplier*/
  if(argv[2][0] == '/')
    {
    sscanf(argv[2]+1, "%f", &s);
    s = 1.0/s;
    }
  else
    sscanf(argv[2], "%f", &s);
  if((fp = fopen(argv[1],
#ifdef MSDOS
    "rb+"
#else
    "r+"
#endif
    )) == NULL)
    {
    fprintf(stderr, "couldn't open input file\n");
    exit(errno);
    }
/*get # of channels from file header*/
  fseek(fp, (long)S_nchans_offset, SEEK_SET);
  num_channels = getc(fp);
  num_channels |= getc(fp)<<8;
/*If the scaling factor is negative, invert the floating-point sign bit of each
  time point in each channel.*/
  if(s < 0)
    {
  /*get # of points from file header*/
    fseek(fp, (long)S_pnts_offset, SEEK_SET);
    num_samples = getc(fp);
    num_samples |= getc(fp)<<8;
  /*seek to end of file header*/
    fseek(fp, (long)(packed_sizeof_SETUP+packed_sizeof_ELECTLOC*num_channels), SEEK_SET);
    for(channel = 0; channel != num_channels; channel++)
      {
    /*seek to end of channel header*/
      fseek(fp, 5L, SEEK_CUR);
      for(sample = 0; sample != num_samples; sample++)
	{
      /*invert the sign bit*/
	fseek(fp, 3L, SEEK_CUR);
	sign_byte = getc(fp);
	sign_byte ^= 0x80;
	fseek(fp, -1L, SEEK_CUR);
	putc(sign_byte, fp);
	}
      }
  /*make the scaling coefficient positive*/
    s *= -1.0;
    }
  fseek(fp, (long)(packed_sizeof_SETUP-packed_sizeof_ELECTLOC+EL_calib_offset+sizeof(float)), SEEK_SET);
  for(channel = 0; channel != num_channels; channel++)
    {
    fseek(fp, (long)(packed_sizeof_ELECTLOC-sizeof(float)), SEEK_CUR);
    calibration_factor = read_Intel_float(fp);
    fseek(fp, (long)(-sizeof(float)), SEEK_CUR);
    write_Intel_float(s*calibration_factor, fp);
    }
  fclose(fp);
  exit(0);
  }
