/*subepoch.c - produce a subepoch of a GnuroScan averaged EEG file.
  Copyright (c) 1996 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include "gnuro.h"
#include "intel.h"

void main(argc, argv)
int argc;
char **argv;
  {
  register int sample, channel, i;
  int begin_sample, end_sample, num_samples, num_channels;
  double xmin, xmax, new_xmin, new_xmax;
  FILE *fullepoch, *subepoch;
  char erp[packed_sizeof_SETUP];
  printf("Copyright (c) 1996 Matthew Belmonte <mkb4@Cornell.edu>.  Please cite.\n");
  if(argc != 5)
    {
    fprintf(stderr, "usage: %s <start_ms> <end_ms> <full_epoch.avg> <sub_epoch.avg>\n", *argv);
    exit(1);
    }
  new_xmin = atof(argv[1])/1000.0;
  new_xmax = atof(argv[2])/1000.0;
  if(new_xmin > new_xmax)
    {
    fprintf(stderr, "empty subrange\n");
    exit(1);
    }
/*open the source file*/
  if((fullepoch = fopen(argv[3],
#ifdef MSDOS
    "rb"
#else
    "r"
#endif
    )) == NULL)
    {
    perror(argv[3]);
    exit(1);
    }
/*read the file header*/
  if(fread(erp, 1, packed_sizeof_SETUP, fullepoch) != packed_sizeof_SETUP)
    {
    perror(argv[3]);
    fclose(fullepoch);
    exit(errno);
    }
  num_channels = S_nchannels(erp);
  num_samples = S_pnts(erp);
  xmin = S_xmin(erp);
  xmax = S_xmax(erp);
  if(new_xmin < xmin)
    new_xmin = xmin;
  if(new_xmax > xmax)
    new_xmax = xmax;
  put_S_xmin(erp, new_xmin);
  put_S_xmax(erp, new_xmax);
  begin_sample = (int)(num_samples*(new_xmin-xmin)/(xmax-xmin));
  end_sample = (int)(num_samples*(new_xmax-xmin)/(xmax-xmin));
  put_S_pnts(erp, end_sample-begin_sample+1);
  if((subepoch = fopen(argv[4],
#ifdef MSDOS
    "wb"
#else
    "w"
#endif
    )) == NULL)
    {
    perror(argv[4]);
    fclose(fullepoch);
    exit(errno);
    }
  fwrite(erp, 1, packed_sizeof_SETUP, subepoch);
  for(i = 0; i != num_channels*packed_sizeof_ELECTLOC; i++)
    putc(getc(fullepoch), subepoch);
  for(channel = 0; channel != num_channels; channel++)
    {
    for(i = 0; i != 5; i++)
      putc(getc(fullepoch), subepoch);
    fseek(fullepoch, begin_sample*(long)sizeof(float), SEEK_CUR);
    for(sample = begin_sample; sample <= end_sample; sample++)
      for(i = 0; i != sizeof(float); i++)
	putc(getc(fullepoch), subepoch);
    fseek(fullepoch, (num_samples-1-end_sample)*(long)sizeof(float), SEEK_CUR);
    }
  fclose(subepoch);
  fclose(fullepoch);
  exit(0);
  }
