/*training_sequence.c - same as sequence.c, but generates longer ITIs.
  Copyright (c) 1996 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

#include <stdio.h>
#include <errno.h>
#include <math.h>
#include "fastshft.h"

#define H ((ST_SLOWEST_RESPONSE-ST_FASTEST_RESPONSE+ST_MSECS_PER_TICK/2)/ST_MSECS_PER_TICK-1)
#define K (ST_LONGEST_ISI/ST_MSECS_PER_TICK)

int choose(lb, ub)
int lb, ub;
  {
  return(lb+(ub-lb+1)*(random()&((1L<<26)-1))/(1L<<26));
  }

void main()
  {
  register int tick, isi, side, stimulus, trial;
  FILE *stim_file;
  char filename[12];
  fprintf(stderr, "Copyright (c) 1996 Matthew Belmonte <mkb4@Cornell.edu>.  Please cite.\n");
  trial = 0;
  while(trial != 10)
    {
    sprintf(filename, "train%d.dat", trial);
    srandom(++trial);
    if((stim_file = fopen(filename, "w")) == NULL)
      {
      perror((char *)0);
      exit(errno);
      }
    for(tick = 0; tick != K; tick++)
      fprintf(stim_file, "1\n3\n");
    side = 1+(random()&2);
    if(side == 3)
      fprintf(stim_file, "1\n");
    for(stimulus = 0; stimulus != 14; stimulus++)
      {
      fprintf(stim_file, "%d\n", side+1);
      isi = choose(K, 2*K-H);
      side = (side+2)%4;
      for(tick = 0; tick != isi; tick++)
        fprintf(stim_file, "%d\n%d\n", side, (side+2)%4);
      }
    fprintf(stim_file, "%d\n", side+1);
    for(tick = 0; tick != K; tick++)
      fprintf(stim_file, "%d\n%d\n", (side+2)%4, side);
    fprintf(stim_file, "254\n");
    fclose(stim_file);
    }
  exit(0);
  }
