% loadacscnt() - 
%
% Usage:
%   >> r = loadacscnt(filename, elec);
%
% Inputs:
%   filename   - name of the ascii file generated using cnttoasc
%   elec       - number of electrodes, default 31
%
% Outputs:
%   r          - output matrix (no event)

% arno@salk.edu, Arnaud Delorme, CNL / Salk Institute, 2001

% This program is free software; you can redistribute it and/or
% modify it.  
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

function r = loadacscnt(filename, elec);

if nargin < 2
   elec = 31;
end;

% open file
% ---------
fid = fopen(filename, 'r');

% skip the first 4 lines
% ----------------------
for index=1:4	fgetl(fid); end;
r = fscanf(fid, '%f', [elec, inf]);

% average referencing
% -------------------
r = r-ones(elec,1)*sum(r,1)/(elec+1);

fclose(fid);
return;
