/*dumpavg.c - create an ASCII dump of a GnuroScan averaged EEG data file.
  Copyright (c) 1996 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include "intel.h"
#include "gnuro.h"

#define CH_MAX 16

void main(argc, argv)
int argc;
char **argv;
  {
  register int sample, channel;
  int num_samples, num_channels, variance_flag;
  float xmin, xmax;
  FILE *avg, *avg_tail;
  char channel_label[CH_MAX][1+EL_lab_length];
  float calibration[CH_MAX];
  fprintf(stderr, "Copyright (c) 1996 Matthew Belmonte <mkb4@Cornell.edu>.  Please cite.\n");
  if(argc != 2)
    {
    fprintf(stderr, "usage: %s <file.avg>\n", *argv);
    exit(1);
    }
  if((avg = fopen(argv[1],
#ifdef MSDOS
    "rb"
#else
    "r"
#endif
    )) == NULL)
    {
    perror(argv[1]);
    exit(errno);
    }
/*read # of channels, # of samples, variance flag, and real time bounds*/
  fseek(avg, (long)S_pnts_offset, SEEK_SET);
  num_samples = getc(avg);
  num_samples |= getc(avg)<<8;
  fseek(avg, (long)S_nchans_offset, SEEK_SET);
  num_channels = getc(avg);
  num_channels |= getc(avg);
  if(num_channels > CH_MAX)
    {
    fprintf(stderr, "Recompile %s with CH_MAX=%d\n", *argv, num_channels);
    fclose(avg);
    exit(1);
    }
  fseek(avg, (long)S_variance_offset, SEEK_SET);
  variance_flag = getc(avg);
  fseek(avg, (long)S_xmin_offset, SEEK_SET);
  xmin = read_Intel_float(avg);
  fseek(avg, (long)S_xmax_offset, SEEK_SET);
  xmax = read_Intel_float(avg);
/*read channel labels and calibrations*/
  fseek(avg, (long)(packed_sizeof_SETUP+EL_lab_offset), SEEK_SET);
  for(channel = 0; channel != num_channels; channel++)
    {
    fread(channel_label[channel], 1, EL_lab_length, avg);
    channel_label[channel][EL_lab_length] = '\0';
    fseek(avg, (long)(EL_calib_offset-(EL_lab_offset+EL_lab_length)), SEEK_CUR);
    calibration[channel] = read_Intel_float(avg);
    fseek(avg, (long)(packed_sizeof_ELECTLOC+EL_lab_offset-(EL_calib_offset+sizeof(float))), SEEK_CUR);
    }
/*if standard deviations have been appended, use a duplicate file pointer*/
  if(variance_flag)
    {
    avg_tail = fopen(argv[1],
#ifdef MSDOS
      "rb"
#else
      "r"
#endif
      );
    fseek(avg_tail, (long)(packed_sizeof_SETUP+num_channels*(packed_sizeof_ELECTLOC+5L+num_samples*sizeof(float))), SEEK_SET);
    }
  fseek(avg, (long)(packed_sizeof_SETUP+num_channels*packed_sizeof_ELECTLOC), SEEK_SET);
  for(channel = 0; channel != num_channels; channel++)
    {
    fseek(avg, 5L, SEEK_CUR);
    printf("%s:\npoint\tms\tpotential (uV)%s\n", channel_label[channel], (variance_flag? "\tSD (uV)": ""));
    for(sample = 0; sample != num_samples; sample++)
      {
      printf("%4d\t%+4.0f\t%+9.6f", sample, 1000.0*(xmin+sample*(xmax-xmin)/(num_samples-1)), calibration[channel]*read_Intel_float(avg));
      if(variance_flag)
	printf("\t%9.6f", read_Intel_float(avg_tail));
      putchar('\n');
      }
    }
  if(variance_flag)
    fclose(avg_tail);
  fclose(avg);
  exit(0);
  }
