/*queue.h - header file for queue.c.
  Copyright (c) 1995 Matthew Belmonte

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  If you find this program useful, please send mail to Matthew Belmonte.
  <mkb4@Cornell.edu>.  If you base a publication on data processed by this
  program, please notify Matthew Belmonte and include the following citation
  in your publication:

	Matthew Belmonte, `A Software System for Analysis of
	Steady-State Evoked Potentials', Association for Computing
	Machinery SIGBIO Newsletter 17:1:9-14 (April 1997).
*/

typedef struct {int ptr, len; QVAL *queue;} QUEUE;
QUEUE *create_queue(int);	/*create a queue to hold up to 'int' items*/
void destroy_queue(QUEUE*);	/*clean up storage when done using a queue*/
void queue_insert(/* QVAL, QUEUE* */); /*insert a new value into a queue*/
QVAL queue_extract(QUEUE*);	/*extract the oldest value from a queue*/
QVAL queue_peek(QUEUE*, int);	/*look at the 'int'th item from the head*/
